<?php get_header(); ?>

<?php 

$post_title = $post->post_title;
$post_content = explode('<!--more-->', strip_shortcodes(wpautop($post->post_content)));
$post_subtitle = strip_shortcodes(wpautop(get_post_meta($post->ID, 'subtitle', true)));
$gallery = get_post_gallery($post->ID, false);
$ids = explode(',', $gallery['ids']);

$option = get_post_meta($post->ID, 'option', true);
$columns = get_post_meta($post->ID, 'columns', true); 
$video = get_post_meta($post->ID, 'video', true);
$video_code = get_post_meta($post->ID, 'video_code', true);

switch ($option) {

 	case '1':
 		$class = 'back-single back-single-'.$columns;
 		break;
 	
 	case '2':
 		$class = 'back-single back-single-video';
 		break;
 	case '3':
 		$class = 'back-single back-single-post';
 		break; 
 	default:
 		break;
 }  ?>

<div class="<?=$class;?>">

	<div class="container">
		
		<div class="int">
			
			<div class="info">
				<div class="titulo">
					<h1><?=$post_title;?></h1>
				</div>

				<div class="autor">
					<?=$post_subtitle;?>
				</div>

				<div class="descripcion">
					<?=$post_content[0];?>
				</div>

				<div class="btn-close">
					<a href="<?=home_url();?>">
						<p><span>close</span></p>
					</a>
				</div>
			</div>
			<?php 
			if($option == '1'): ?>
				<div class="grid">
					
					<?php 
					foreach($ids as $id):
						$image = $image = wp_get_attachment_url($id); ?>
					
						<div class="item">
							
							<div class="img-container">
								<img src="<?=$image;?>" alt="">
							</div>
						</div>
						<?php 
					endforeach; ?>
				</div>
				<?php 
			else: 	if($option == '2'){ ?>
						<div class="video">
						
							<div class="video-container">
								<?php 
								if($video == 'vimeo'):

									$iframe = '<iframe src="https://player.vimeo.com/video/'.$video_code.'?title=0&byline=0&portrait=0" width="640" height="360" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
									echo $iframe;
									
								else:	if($video == 'youtube'){ 

											$iframe = '<iframe width="560" height="315" src="https://www.youtube.com/embed/'.$video_code.'" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>';
											echo $iframe;			
										}
								endif; ?>
							</div>
						</div>
						<?php 
					} else	if($option == '3'){ 	?>
								<div class="post">
									<?=$post_content[1];?>
								</div>
								<?php 
							}		
			endif; ?>
		</div>
		
	</div>
			
</div>
<?php get_footer(); ?>