/**-------------------------------------------------------------------------------------------**/
/**						   	               Expand-Menu                                        +*/  
/**-------------------------------------------------------------------------------------------**/

	function expandMenu(args){

		const $claseAgregarEntrada = args.enterClass || "visible"
		const $claseAgregarSalida = args.leaveClass || "unvisible"

		const $menu = args.menu || ".menu"
		const $btn = args.btn || ".btn-hamburguesa"

		const $hide = args.hideScroll || false
		const $hideTop = args.hideTop || -60;

		let $index = true
		let $scrollMenu = true
		

		$($btn).click(function() {
			if ($index){
				$($menu).addClass($claseAgregarEntrada);

				$index = false;
				$scrollMenu = false
			}
			else if(!$index){
				$($menu).addClass($claseAgregarSalida);
				$($menu).one("animationend", function(){
					$($menu).removeClass($claseAgregarSalida);
				})
				$($menu).removeClass($claseAgregarEntrada);
				$index = true;
				$scrollMenu = true
			}
		})

		if($(window).width() < 678){

			$(`${$menu} li`).click(function(){
				$($menu).addClass($claseAgregarSalida);
				$($menu).one("animationend", function(){
					$($menu).removeClass($claseAgregarSalida);
				})
				$($menu).removeClass($claseAgregarEntrada);
				$index = true;
				$scrollMenu = true
			})

		}
		else{

		}

		$(window).resize(function(){
			if($(window).width() < 678){

				$(`${$menu} li`).click(function(){
					$($menu).addClass($claseAgregarSalida);
					$($menu).one("animationend", function(){
						$($menu).removeClass($claseAgregarSalida);
					})
					$($menu).removeClass($claseAgregarEntrada);
					$index = true;
					$scrollMenu = true
				})

			}
			else{
			
			}
		})
		


		$(window).resize(function() {
			$index = true;
			$($menu).removeClass($claseAgregarEntrada);
		})

		if($hide){
			var posicionDeLaUltimaVezQueHicisteScroll = window.pageYOffset;
			window.onscroll = function() {
			var posicionDelScrollActual = window.pageYOffset;
				if (posicionDeLaUltimaVezQueHicisteScroll > posicionDelScrollActual) {
					$(".back-menu").css("top", "0")
				} 
				else if($scrollMenu){
					$(".back-menu").css("top", `${$hideTop}px`)
				}

				posicionDeLaUltimaVezQueHicisteScroll = posicionDelScrollActual;
			}
		}

		console.log("Menu Plugin Its OK!")
	}

/**-------------------------------------------------------------------------------------------**/
/**                               Animacion para rutas internas                               +*/  
/**-------------------------------------------------------------------------------------------**/

	function scrollTo(args){

		let $btn = $(args.btn)
		let $goTo = $(args.irHasta)
		let $offSet = args.offset || 100
		let $time = args.time || 300

		$($btn).click(function (){
            $('html, body').animate({
                scrollTop: $($goTo).offset().top - $offSet
            }, $time);

        });
	}

/**-------------------------------------------------------------------------------------------**/
/**                              Funciones de Textos en Consola                               +*/  
/**-------------------------------------------------------------------------------------------**/

	function consola(args){
		const $texto = args.texto
		const $confirm = args.confirm || false
		const $error = args.error || false


		if($confirm && $error){
			console.log(
				`%cPerdon pero Elige un sola opción para tu mensaje: o es de confirmacion o es de Error`,
				`
					font-size: 12px;
					color: white;
					background-color: red;
					border-radius: 50px;
					padding: 10px;
				`
			)
		}
		else if($confirm){
			console.log(
				`%c${$texto}`,
				`
					font-size: 12px;
					color: white;
					background-color: lightgreen;
					border-radius: 8px;
					padding: 5px;
				`
			)
		}
		else if($error){
			console.log(
				`%c${$texto}`,
				`
					font-size: 12px;
					color: white;
					background-color: red;
					border-radius: 8px;
					padding: 5px;
				`
			)
		}
	}

/**-------------------------------------------------------------------------------------------**/
/**               Funciones para comprobar si existe el objeto en la pagina actual            +*/  
/**-------------------------------------------------------------------------------------------**/

	function existe($selector){
		if($($selector).length){
			return true
		}
		else{
			return false
		}
	}

/**-------------------------------------------------------------------------------------------**/
/**                         Funcion para Checar si una imagen es Obscura                      +*/  
/**-------------------------------------------------------------------------------------------**/

	function imagenObscura(imageSrc,callback) {
	    var fuzzy = 0.1;
	    var img = document.createElement("img");
	    img.src = imageSrc;

	    img.onload = function() {
	        // create canvas
	        var canvas = document.createElement("canvas");
	        canvas.width = this.width;
	        canvas.height = this.height;

	        var ctx = canvas.getContext("2d");
	        ctx.drawImage(this,0,0);

	        var imageData = ctx.getImageData(0,0,canvas.width,canvas.height);
	        var data = imageData.data;
	        var r,g,b, max_rgb;
	        var light = 0, dark = 0;

	        for(var x = 0, len = data.length; x < len; x+=4) {
	            r = data[x];
	            g = data[x+1];
	            b = data[x+2];

	            max_rgb = Math.max(Math.max(r, g), b);
	            if (max_rgb < 128)
	                dark++;
	            else
	                light++;
	        }

	        var dl_diff = ((light - dark) / (this.width*this.height));
	        if (dl_diff + fuzzy < 0)
	            callback(true); /* Dark. */
	        else
	            callback(false);  /* Not dark. */
	    }
	}











