<?php get_header(); ?>

	<div class="back-home">
		<div class="container">	
			<div class="home">
				<div class="grid">		
					<?php 
					$home_page = get_page_by_path('home');

					$galleries = get_post_galleries($home_page->ID, false);
					
					foreach($galleries as $gallery): ?>

						<div class="fila"> <!-- Maximo 5 items dentro de cada fila -->
							<?php 

							$gallery_ids = explode(',', $gallery['ids']);
							$item = 0;
							foreach($gallery_ids as $id):

								$image = wp_get_attachment_url($id);
								$image_size = get_post_meta($id, 'image_size', true); 
								$url = wp_get_attachment_caption($id);
								
								switch($image_size){

									case '1': 
										$class = 'class="item"';
										break;
									case '2':
										$class = 'class="item x2"';
										break;
									case '3':
										$class = 'class="item x3"';
										break;
									default:
										$class = 'class="item"';
										break;
								} ?>
								<!-- 
								Se manejan diferentes tamaños para que cada imagen tome
								un tamaño en especifico:

								Chico: "solo clase base (.item)"
								Mediana: "clase base mas la clase '.x2' "
								Large: "clase base mas la clase '.x3' "  -->
								<?php 
								if($url): ?>
									<div <?=$class;?>>
										<a href="<?=$url;?>">
											<div class="img-container">
												<img src="<?=$image;?>" alt="">
											</div>
										</a>
									</div>
									<?php
								else: ?>
									<div <?=$class;?>>
										<div class="img-container">
											<img src="<?=$image;?>" alt="">
										</div>
									</div>
									<?php 
								endif; 
								$item ++ ;
								if($item == 5) break;
							endforeach; ?>
						</div>
						<?php 
					endforeach; ?>	
				</div>
			</div>	
		</div>	
	</div>
<?php get_footer(); ?>
