<!DOCTYPE html>
<html lang="es">
<head>
	<?php 
	$site_title=get_bloginfo( 'name' );
	$site_description=get_bloginfo( 'description');
	$templateURL=get_template_directory_uri().'/';
	$homeURL=home_url(); ?>

	<title><?=$site_title;?></title>
	<meta name="lang" content="es" />
	<meta charset="utf-8" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="format-detection" content="address=no,email=no,telephone=no">
	<meta name="viewport" content="width=device-width, initial-scale=1.0 user-scalable=no">
	<meta name="theme-color" content="#fff">
	
	<?php

	$share_image = wp_get_attachment_url(get_option('share-image'));

	if(is_single() || is_page()){

		global $post;

		$title = $post->post_title . ' - ' . get_bloginfo('name');
		$description = strip_shortcodes( substr($post->post_content, 0, 60) );
		$link = get_the_permalink($post->ID);
		$has_image = get_the_post_thumbnail_url($post->ID, 'large'); 
		$image = ($has_image)?$has_image:$share_image; ?>

		<script type="text/javascript"> 
			var post_id = "<?=$post->ID;?>"; 
		</script>

		<?php 
	}
	else {

		$title = get_bloginfo('name');
		$description = get_bloginfo('description');
		$link = home_url();
		$image = $share_image;  ?>

		<script type="text/javascript"> 
			var post_id = false;
		</script>
		<?php 
	} ?>
		<meta name="description" content="<?=$description;?>" />
		<meta property="og:type" content="website" />
		<meta property="og:title" content="<?=$title;?>"/>
		<meta property="og:site_name" content="<?=$title;?>"/>
		<meta property="og:description" content="<?=$description;?>"/>
		<meta property="og:image" itemprop="image" content="<?=$image;?>"/>
		<meta property="og:image:width" content="300" />
		<meta property="og:image:height" content="200" /> 
		<meta property="og:url" content="<?=$link;?>" />
		<meta name="twitter:card" content="summary_large_image" />
		<meta name="twitter:title" content="<?=$title;?>" />
		<meta name="twitter:description" content="<?=$description;?>" />
		<meta name="twitter:image" content="<?=$image;?>" />
		<meta name="twitter:image:width" content="400" />
		<meta name="twitter:image:height" content="300" /> 
		
		<?php 
		$favicon = wp_get_attachment_url(get_option('favicon')); ?>
		<link rel="shortcut icon" type="image/x-icon" href="<?=$favicon?>">
		
		<?php 

		$code = get_option('google-analytics'); 

		if($code): ?>
			<!-- Global site tag (gtag.js) - Google Analytics -->
			<script async src="https://www.googletagmanager.com/gtag/js?id=<?=$code;?>"></script>
			<script>
			  window.dataLayer = window.dataLayer || [];
			  function gtag(){dataLayer.push(arguments);}
			  gtag('js', new Date());

			  gtag('config', '<?=$code;?>');
			</script>
			<?php  
		endif; ?>
	<?php wp_head(); ?>
</head>
<body>

	<div class="wrapper">

<?php include 'menu.php'; ?>
	