<?php 
add_filter( 'attachment_fields_to_edit', function($form_fields, $post){

	$image_size = get_post_meta($post->ID, 'image_size', true);
    $image = wp_get_attachment_url($post->ID);

    $form_fields['image_size'] = [
        'label' => 'Image Size:',
        'input' => 'html',
        'html' => "
            <select name='attachments[{$post->ID}][image_size]' class='fields_class attachment_class' id='attachments[{$post->ID}][image_size]' data-id='".$post->ID."'>
                <option value='0'>Select an option</option>
                <option value='1'>Option 1</option>
                <option value='2'>Option 2</option>
                <option value='3'>Option 3</option>
            </select>",
        'extra_rows' => [
            'class_option1' => '<img class="image_prev" src="'.$image.'"/>',
            'class_option2' => '<img class="image_prev" src="'.$image.'"/>',
            'class_option3' => '<img class="image_prev" src="'.$image.'"/>' ]
        ];
    
    return $form_fields;


}, 10, 2 );  ?>