<?php 
add_action('admin_enqueue_scripts', function() use ($templateURL){

    wp_enqueue_style( 'admin', $templateURL . 'css/admin.css' );
    wp_enqueue_style('fontawesome', 'https://use.fontawesome.com/releases/v5.7.0/css/all.css');

    if($pagenow != 'nav-menus.php') wp_enqueue_script( 'sortable', $templateURL . 'js/jquery.sortable.min.js', [], FALSE, FALSE );
    
    wp_enqueue_script( 'admin', $templateURL . 'js/admin.js', [], FALSE, FALSE );
   
    if(is_admin()){
        wp_enqueue_media();
    }
    
	$screen = get_current_screen();

	if($screen->base == 'post'){

    	wp_enqueue_style( 'post_style', $templateURL . 'css/post_style.css' );
    	wp_enqueue_script( 'post_code', $templateURL . 'js/post_code.js', FALSE, FALSE, FALSE);

    	$option = get_post_meta($_GET['post'], 'option', true);
    	$columns = get_post_meta($_GET['post'], 'columns', true); 
    	$video = get_post_meta($_GET['post'], 'video', true);
        $video_code = get_post_meta($_GET['post'], 'video_code', true);

    	$data = "options.option = " . (($option)?$option:0) . ";
				 options.columns = '" . $columns . "' ;
				 options.video = '" . $video . "' ;
                 options.video_code = '" . $video_code . "' ; ";

    	wp_add_inline_script('post_code' , $data, 'after' );

        //----------------------------------------------------------
        
        wp_enqueue_style('attachment_fields_style',$templateURL.'css/attachment_fields_style.css');
        wp_enqueue_script( 'attachments_fields', $templateURL . 'js/attachment_fields_code.js', FALSE, FALSE, FALSE);

        $galleries = get_post_galleries($_GET['post'], false);
        $galleries_js = [];

        foreach($galleries as $gallery):
            $gallery_ids = explode(',', $gallery['ids']);
            foreach($gallery_ids as $id):

                $attachment_option = get_post_meta($id, 'image_size', true);
                $galleries_js[$id] = empty($attachment_option)?0:$attachment_option;
            endforeach;
        endforeach;
        
        $data_attachment='attachment.options =' . json_encode($galleries_js, JSON_FORCE_OBJECT) .';';
        wp_add_inline_script('attachments_fields' , $data_attachment, 'after' );
}
}); ?>