<?php

add_action( 'add_meta_boxes', function(){

	add_meta_box('options', 'Post Options', function($post)
    {   
?>
		<table>
			<tbody>
				<tr>
					<td class="options">
						<select class="options_select" name="options">
					   		<option value="0">Select an Option</option>
					   		<option value="1">Images Columns</option>
					   		<option value="2">Video</option>
					   		<option value="3">Text only</option>
					   	</select>
					</td>
					<td class="columns">
						<select class="columns_select" name="columns">
					   		<option value="grid-1">1</option>
					   		<option value="grid-2">2</option>
					   		<option value="grid-3">3</option>
					   		<option value="grid-4">4</option>
					   	</select>
					</td>
					<td class="video">
						<select class="video_select" name="video">
							<option value="youtube">YouTube</option>
							<option value="vimeo">Vimeo</option>
						</select>
					</td>
					<td class="video">
						<label for="video_code">Code:</label>
						<input type="text" id="video_code" class="video_code" name="video_code">
					</td>
					<td class="text_only">
						<strong>Remember to put <i>&#x3C;!-- more --&#x3E;</i> between the two contents</strong>
					</td>
				</tr>
			</tbody>
		</table>
       	
		<?php 
    },'post','normal');

    add_meta_box('subtitle_metabox', 'Subtitle', function($post){

        $subtitle=get_post_meta($post->ID, 'subtitle', true); ?>

        <div> 
            <?php wp_editor($subtitle, 'subtitle', ['textarea_rows' => 1]); ?>
        </div>
        <?php 
    },['post', 'page'],'normal');

    add_meta_box('title_metabox', 'Title', function($post){

        $title=get_post_meta($post->ID, 'title', true); ?>

        <div> 
            <?php wp_editor($title, 'title2', ['textarea_rows' => 1]); ?>
        </div>
        <?php 
    },['page'],'normal');

});  ?>